/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.Arrays;
import jpcsp.Emulator;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.crypto.CryptoEngine;
import jpcsp.graphics.capture.CaptureImage;
import jpcsp.hardware.Model;
import jpcsp.settings.Settings;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceResmgr
extends HLEModule {
    public static Logger log = Modules.getLogger("sceResmgr");
    public static final String dummyIndexDatContent = "release:2.00:\nbuild:0000,0,3,1,0:builder@vsh-build6\nsystem:57716@release_660,0x06060010:\nvsh:p6616@release_660,v58533@release_660,20110727:\ntarget:1:WorldWide\n";

    @Override
    public void start() {
        sceResmgr.createDummyIndexDat();
        this.createDummyBackgroundImages();
        super.start();
    }

    private static void createDummyIndexDat() {
        int firmwareVersion = Emulator.getInstance().getFirmwareVersion();
        String fileNameFormat = firmwareVersion == 0 || firmwareVersion >= 500 ? "flash0:/vsh/etc/index_%02dg.dat" : "flash0:/vsh/etc/index.dat";
        String indexDatFileName = String.format(fileNameFormat, Model.getGeneration());
        byte[] content = Utilities.readCompleteFile(indexDatFileName);
        if (content != null && content.length > 0) {
            return;
        }
        if (firmwareVersion == 0 || firmwareVersion >= 250) {
            int tag;
            byte[] buffer = new byte[496];
            Utilities.write8(buffer, 124, 0);
            Utilities.writeUnaligned32(buffer, 176, 159);
            Utilities.writeUnaligned32(buffer, 180, 128);
            switch (Model.getGeneration()) {
                case 1: {
                    tag = 187404528;
                    break;
                }
                case 2: {
                    tag = 187404784;
                    break;
                }
                default: {
                    tag = 187405040;
                }
            }
            Utilities.writeUnaligned32(buffer, 208, tag);
            Utilities.writeStringNZ(buffer, 336, buffer.length - 336, dummyIndexDatContent);
            Utilities.writeCompleteFile(indexDatFileName, buffer, true);
        } else {
            byte[] buffer = dummyIndexDatContent.getBytes();
            Utilities.writeCompleteFile(indexDatFileName, buffer, true);
        }
    }

    private void createDummyBackgroundImages() {
        String directory = String.format("%s/vsh/resource", Settings.getInstance().getDirectoryMapping("flash0"));
        File baseDirectory = new File(directory);
        if (baseDirectory.isDirectory()) {
            String[] fileNames = baseDirectory.list();
            if (fileNames != null && fileNames.length >= 12) {
                return;
            }
        } else {
            baseDirectory.mkdirs();
        }
        int imageWidth = 60;
        int imageHeight = 34;
        int[] buffer = new int[2040];
        int[] monthColors = new int[]{0xE3E3E3, 4842997, 1695892, 10585842, 693514, 11296413, 9480960, 10040842, 14375882, 1686766, 1592183, 1514476};
        for (int month = 1; month <= 12; ++month) {
            int monthColor = monthColors[month - 1];
            Arrays.fill(buffer, monthColor);
            CaptureImage image = new CaptureImage(0, 0, IntBuffer.wrap(buffer), 60, 34, 60, 3, false, 0, false, true, null);
            String fileName = String.format("%s/%02d.bmp", directory, month);
            image.setFileFormat("bmp");
            image.setFileName(fileName);
            try {
                image.write();
                continue;
            }
            catch (IOException e) {
                log.error((Object)"write BMP", (Throwable)e);
            }
        }
    }

    @HLEFunction(nid=-1648277359, version=150)
    public int sceResmgr_9DC14891(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.inout) TPointer buffer, int bufferSize, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 resultLengthAddr) {
        int resultLength;
        if ("release:".equals(buffer.getStringNZ(0, 8))) {
            resultLength = bufferSize;
        } else {
            byte[] buf = buffer.getArray8(bufferSize);
            int result = new CryptoEngine().getPRXEngine().DecryptPRX(buf, bufferSize, 9, null, null);
            if (result < 0) {
                log.error((Object)String.format("sceResmgr_9DC14891 returning error 0x%08X", result));
                return result;
            }
            resultLength = result;
            buffer.setArray(buf, resultLength);
        }
        resultLengthAddr.setValue(resultLength);
        return 0;
    }
}

